<?php

namespace HS\Http\Controllers\Auth;

use Illuminate\Http\Request;
use HS\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cookie;

class RelayRedirectController extends Controller
{
    /**
     * Handle the incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function __invoke(Request $request)
    {
        $intended = Cookie::get('intended-url');

        if ($intended) {
            Cookie::queue(Cookie::forget('intended-url'));
            return redirect($intended);
        }

        return redirect()->route('admin');
    }
}
