<?php

namespace HS\Install\Updater\Updates\Tasks;

use Facades\HS\Cache\Manager;
use Illuminate\Support\Facades\DB;

use HS\Install\Updater\Updates\BaseUpdate;

class HelpSpotFivePortalTerms extends BaseUpdate
{
    protected $version = '5.0.67';

    public function run()
    {
        $portalTerms = $this->db->table('HS_Settings')->where('sSetting', 'cHD_PORTAL_TERMS')->first();

        if (! $portalTerms) {
            DB::table('HS_Settings')->insert( ['sSetting' => 'cHD_PORTAL_TERMS', 'tValue' => ''] );
            DB::table('HS_Settings')->insert( ['sSetting' => 'cHD_PORTAL_PRIVACY', 'tValue' => ''] );
            Manager::forget(Manager::key('CACHE_SETTINGS_KEY'));
        }
    }
}
