<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */
require_once cBASEPATH.'/helpspot/lib/api.kb.lib.php';

/**
 * Get the latest forum topics and return as array.
 */
class Savant2_Plugin_KB_Tree extends Savant2_Plugin
{
    /**
     * Store result set here.
     *
     *
     * @var ADODB Record Set
     */
    public $rs = [];

    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {
        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Create tree and set to rs.
     *
     *
     * @param type and id
     *
     * @return none
     */
    public function _buildTree($idtype, $id)
    {
        //If  type is bookid then nothing to do, just pass id

        if ($idtype == 'chapid') {
            $chapter = apiGetChapter($id);
            $id = $chapter['xBook'];
        } elseif ($idtype == 'pageid') {
            $page = apiGetPage($id);
            $chapter = apiGetChapter($page['xChapter']);
            $id = $chapter['xBook'];
        }

        $this->rs = apiBuildChapPageTree($id, false);
    }

    /**
     * Return array of book info.
     *
     *
     * @param bookid
     *
     * @return array of book info
     */
    public function getBook($id)
    {
        $book = apiGetBook($id);

        if (! $book || $book['fPrivate'] != 0) {
            $book = false;
        }

        return $book;
    }

    /**
     * Return array of books.
     *
     *
     * @param none
     *
     * @return array of books
     */
    public function getChapters($id)
    {
        if (empty($this->rs)) {
            $this->_buildTree('bookid', $id);
        }

        return (array) apiTocChaps($this->rs);
    }

    /**
     * Return array of chapter info.
     *
     *
     * @param chapterid
     *
     * @return array of chapter info
     */
    public function getChapter($id)
    {
        if (empty($this->rs)) {
            $this->_buildTree('chapid', $id);
        }

        $chapter = apiChapFromTree($this->rs, $id);

        if (! $chapter || $chapter['fHidden'] != 0 || $chapter['fPrivate'] != 0) {
            $chapter = false;
        }

        return $chapter;
    }

    /**
     * Return array of pages for chapter.
     *
     *
     * @param Chapter id
     *
     * @return array of books
     */
    public function getPages($id)
    {
        if (empty($this->rs)) {
            $this->_buildTree('chapid', $id);
        }

        $pages = apiTocPages($this->rs, $id);
        foreach ($pages as $k=>$page) {
            $pages[$k]['tPage'] = formatKBBody($page['tPage']);
        }

        return (array) $pages;
    }

    /**
     * Return array of page info.
     *
     *
     * @param pageid
     *
     * @return array of page info
     */
    public function getPage($id)
    {
        if (empty($this->rs)) {
            $this->_buildTree('pageid', $id);
        }

        $page = apiPageFromTree($this->rs, $id);

        if ($page && $page['fHidden'] == 0 && $page['fPrivate'] == 0) {
            //Determine if we need to add BR or not
            $page['tPage'] = formatKBBody($page['tPage']);
        } else {
            $page = false;
        }

        return $page;
    }

    /**
     * Return string linke to next page.
     *
     *
     * @param chap or page id
     *
     * @return string link
     */
    public function getNextPage($id)
    {
        $page = isset($_GET['pg']) ? $_GET['pg'] : 'home';
        if ($page == 'kb.chapter') {
            if ($chapter = getNextKbChapter($id)) {
                return '<a href="index.php?pg=kb.chapter&id='.$chapter['xChapter'].'" class="nextprev">'.$chapter['sChapterName'].'</a> &#8594;';
            }
        } elseif ($page == 'kb.page') {
            if ($arr = getNextKbPage($id)) {
                return '<a href="index.php?pg=kb.page&id='.$arr['xPage'].'" class="nextprev">'.$arr['sPageName'].'</a> &#8594;';
            }
        }
    }

    /**
     * Return string linke to prev page.
     *
     *
     * @param chap or page id
     *
     * @return string link
     */
    public function getPrevPage($id)
    {
        $page = isset($_GET['pg']) ? $_GET['pg'] : 'home';
        if ($page == 'kb.chapter') {
            if ($chapter = getPrevKbChapter($id)) {
                return '&#8592; <a href="index.php?pg=kb.chapter&id='.$chapter['xChapter'].'" class="nextprev">'.$chapter['sChapterName'].'</a>';
            }
        } elseif ($page == 'kb.page') {
            if ($arr = getPrevKbPage($id)) {
                return '&#8592; <a href="index.php?pg=kb.page&id='.$arr['xPage'].'" class="nextprev">'.$arr['sPageName'].'</a>';
            }
        }
    }

    /**
     * Return array of crumbs.
     *
     *
     * @param pageid
     *
     * @return array of crumbs
     */
    public function getCrumbToPage($id)
    {
        $crumb = $GLOBALS['DB']->GetRow('SELECT HS_KB_Pages.sPageName, HS_KB_Chapters.sChapterName, HS_KB_Books.sBookName,
												HS_KB_Pages.xPage, HS_KB_Chapters.xChapter, HS_KB_Books.xBook
										  FROM HS_KB_Pages,HS_KB_Chapters,HS_KB_Books
										  WHERE HS_KB_Pages.xPage = ? AND HS_KB_Pages.fHidden = 0
										  AND HS_KB_Pages.xChapter = HS_KB_Chapters.xChapter
										  AND HS_KB_Chapters.xBook = HS_KB_Books.xBook', [$id]);
        $GLOBALS['navOn'] = 'kb'.$crumb['xBook'];

        return $crumb;
    }

    /**
     * Return array of crumbs.
     *
     *
     * @param chapid
     *
     * @return array of crumbs
     */
    public function getCrumbToChapter($id)
    {
        $crumb = $GLOBALS['DB']->GetRow('SELECT HS_KB_Chapters.sChapterName, HS_KB_Books.sBookName,
												HS_KB_Chapters.xChapter, HS_KB_Books.xBook
										  FROM HS_KB_Chapters,HS_KB_Books
										  WHERE HS_KB_Chapters.xChapter = ? AND HS_KB_Chapters.fHidden = 0
										  AND HS_KB_Chapters.xBook = HS_KB_Books.xBook', [$id]);
        $GLOBALS['navOn'] = 'kb'.$crumb['xBook'];

        return $crumb;
    }

    /**
     * Return record count of books in DB.
     *
     *
     * @param none
     *
     * @return number count
     */
    public function count()
    {
        return count($this->rs);
    }
}
