<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */
require_once cBASEPATH.'/helpspot/lib/api.kb.lib.php';

/**
 * Get tag cloud.
 */
class Savant2_Plugin_Tags extends Savant2_Plugin
{
    /**
     * Store result set here.
     *
     *
     * @var ADODB Record Set
     */
    public $rs = [];

    //Results of tag search
    public $searchResults = [];

    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {
        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Set array of docs to rs.
     *
     *
     * @param none
     *
     * @return none
     */
    public function _setTags()
    {
        $this->rs = apiGetTagsWPopularity();
    }

    /**
     * Return array of cloud tags.
     *
     *
     * @param none
     *
     * @return array of tags
     */
    public function getCloud()
    {
        if (empty($this->rs)) {
            $this->_setTags();
        }

        return $this->rs;
    }

    /**
     * Return record count of books in DB.
     *
     *
     * @param none
     *
     * @return number count
     */
    public function count()
    {
        if (empty($this->rs)) {
            $this->_setTags();
        }

        return count($this->rs);
    }

    /**
     * Get name of a tag.
     *
     *
     * @param tag id
     *
     * @return string of tag name
     */
    public function getTagName($id)
    {
        return apiGetTagById($id);
    }

    /**
     * Search kb tags.
     *
     *
     * @param tag id
     *
     * @return matching tags
     */
    public function searchKBTags($id)
    {
        $result = apiTagSearchPortalPages($id);

        return $result;
    }

    /**
     * Search page result count.
     *
     *
     * @param tag id
     *
     * @return matching tags
     */
    public function searchCount($query)
    {
        //Break out the words and find tags that match
        $words = explode(' ', $query);
        $this->_searchResults = apiGetTagsWPopularity($words);

        return count($this->_searchResults);
    }

    /**
     * Search tag results.
     *
     *
     * @param tag id
     *
     * @return matching tags
     */
    public function searchTags($query)
    {
        return $this->_searchResults;
    }
}
