<?php

namespace HS\Domain\Documents;

use Illuminate\Support\Str;

class RequestAttachments
{
    public $files = [];

    public function __construct() {}

    public function reattach($body, $docs = [])
    {
        $rct = 1000;
        foreach ($docs as $k=>$reattach_id) {
            $document = $this->getDocument($reattach_id);
            $document['sCID'] = $this->setCid($document['sCID']);

            // Replace the body and for every br force a newline. See #1325
            $body = str_replace('<br />', "<br />\n", $body);
            $body = inlineImageReplacer($body);

            if (Str::contains($body, '##'.lg_inline_image)) {
                $body = preg_replace('/##'.lg_inline_image.'(\s+)\('.base64_encode($document['sFilename']).'\)##/', '<img src="cid:'.$document['sCID'].'" />', $body);
                $body = preg_replace('/##'.lg_inline_image.'(\s+)\('.$document['sFilename'].'\)##/', '<img src="cid:'.$document['sCID'].'" />', $body);
            }

            if (! hs_empty($document['sFileLocation'])) {
                // If starts with S3, we need to get it from S3 to copy it to a new file
                if (strpos($document['sFileLocation'], 's3://') !== false) {
                    $reattachFilePath = $this->copyS3File($document['sFileLocation']);
                } else {
                    // just pass the full path and api.requests.lib will rename and resave it.
                    $reattachFilePath = hs_setting('cHD_ATTACHMENT_LOCATION_PATH') . $document['sFileLocation'];
                }
            } else {
                // it's a blob so just use what we have stored.
                $reattachFilePath = file_get_contents($document['blobFile']);
            }

            //Add other file meta info as long as we have the file path or body.
            if ($reattachFilePath) {
                $this->files['doc']['error'][$rct] = 0;
                $this->files['doc']['name'][$rct] = $document['sFilename'];
                $this->files['doc']['type'][$rct] = $document['sFileMimeType'];
                $this->files['doc']['tmp_name'][$rct] = $reattachFilePath;
                $this->files['doc']['size'][$rct] = '';
                $this->files['doc']['xDocumentId'][$rct] = ''; //$reattach_id; Do not include the id so api.requests.lib treats it as a new file.
                $this->files['doc']['is_reattach'][$rct] = true;
                $this->files['doc']['content-id'][$rct] = $document['sCID'];
                $this->files['doc']['is_inline'][$rct] = in_array($document['sFileMimeType'], $GLOBALS['imageMimeTypes']);
                $this->files['doc']['transaction'][$rct] = get_transaction_id();
            }

            $rct++;
        }

        return $body;
    }

    /**
     * Move a file from s3 to file system
     *
     * @param $original
     * @return false|string
     */
    public function copyS3File($original)
    {
        try {
            $file = (new S3File($original))->toSpl();
            return $file->getPathname();
        } catch (\Exception $exception) {
            return false;
        }
    }

    /**
     * Set a SCID if it doesn't have one.
     * @param $sCID
     * @return mixed|string
     */
    public function setCid($sCID)
    {
        if (! preg_match('/@/', $sCID)) {
            $hostname = parse_url(cHOST, PHP_URL_HOST);
            return Str::random(10).'@'.$hostname;
        }
        return $sCID;
    }

    /**
     * Grab the document from the db
     *
     * @param $id
     * @return mixed
     */
    public function getDocument($id)
    {
        return apiGetDocumentWithBlob($id);
    }
}
