<?php

namespace HS\Mail\Mailer;


use HS\Mailbox;

class SmtpSettings
{
    /**
     * @var null|int
     */
    private $mailbox;

    /**
     * SmtpSettings constructor.
     * @param null $mailbox
     */
    public function __construct($mailbox=null)
    {
        $this->mailbox = $mailbox;
    }

    /**
     * @return SMTP
     * @throws \Exception
     */
    public function settings()
    {
        return ($this->mailbox)
            ? $this->customSmtp()
            : $this->defaultSmtp();
    }

    /**
     * @return SMTP|bool
     * @throws \Exception
     */
    protected function customSmtp()
    {
        if (! isset($GLOBALS['mailbox_smtp_settings'][$this->mailbox])) {
            $mailbox = Mailbox::find($this->mailbox);
            $GLOBALS['mailbox_smtp_settings'][$this->mailbox] = $mailbox;
        }

        if( $GLOBALS['mailbox_smtp_settings'][$this->mailbox] ) {
            return SMTP::fromHelpSpotSettings($GLOBALS['mailbox_smtp_settings'][$this->mailbox]);
        } elseif(config()->get('mail.default') != 'smtp') {
            // If no custom SMTP for this mailbox,
            // and default outgoing is sendmail, then return false
            return false;
        }

        return SMTP::fromDefault();
    }

    /**
     * @return SMTP
     * @throws \Exception
     */
    protected function defaultSmtp()
    {
        return SMTP::fromDefault();
    }
}
