<?php

return [
    /**
     * Set custom timing for how often email mailboxes are checked for mail
     * example .env setting:
     * MAIL_CRON_INTERVAL="* * * * *"
     */
    'mail_cron_interval' => env('MAIL_CRON_INTERVAL', '* * * * *'),

    /**
     * Enable (default) or Disable mail collection
     * example .env setting:
     * AUTO_COLLECT_MAIL=false
     */
    'collect_mail' => env('AUTO_COLLECT_MAIL', true),

    /**
     * Add a delay between mail sends to help with services that throttle sends over time
     * example .env setting:
     * SEND_MAIL_DELAY=5
     */
    'send_mail_delay' => env('SEND_MAIL_DELAY', 1),

    /**
     * Put HelpSpot into maintenance mode
     * example .env setting:
     * MAINTENANCE_MODE=true
     */
    'maintenance_mode' => env('MAINTENANCE_MODE', false),

    /**
     * Disable CSRF protection to certain routes, comma separated list of routes
     * example .env setting:
     * DISABLE_CSRF_FOR="https://example.org/my-route,https://example.org/index.php?pg=login"
     */
    'disable_csrf' => env('DISABLE_CSRF', ''),

    /**
     * Used in HelpSpot Cloud: Don't run certain tasks during update
     *                         These tasks are instead meant to be run manually
     *                         with external tooling
     */
    'large_update_mode' => env('LARGE_UPDATE_MODE', false),

    /**
     * Force HelpSpot to generate URL's with "https://" no matter
     * what X-Forwarded headers are (or are not) present and despite
     * trusted proxy configuration
     */
    'force_https' => env('FORCE_HTTPS', false),

    'hosted' => env('hosted', false),

    'profile' => env('PROFILE', false),
];
