# HelpSpot Helpers

Here are a collection of a few things to help you install and use HelpSpot on Linux systems.

## What's Included

1. `init` configurations: Configurations to help you run HelpSpot 5's queue worker 
2. `cron` configuration: Configuration to help you run HelpSpot 5's periodic tasks

## CRON

The included `cron/helpspot` file is an example that can be added to a crontab or a file placed in `/etc/cron.d` if that location is configured within your server.

This will run the `php hs schedule:run` command available in HelpSpot 5, which should be run every 1 minute.

The `schedule:run` command, in turn, runs several other periodic tasks at different intervals. It keeps track of when to run those itself, which allows you to only care about
the one `schedule:run` command.

## Init

These init scripts configure HelpSpot 5's queue worker to run. Using an init system such as `systemd` or `supervisord` will restart the queue worker if it fails, and ensure it's running 
if the server is rebooted.

**Supervisord** is recommended as it allows you to run more than one queue worker process easily.

**Systemd** is available on most Linux systems without needing to install extra software. A limitation is that a service can only run one process, but multiple queue workers is often desired.

### Supervisord

The `helpers/init/helpspot-supervisord.conf` file can go into the `/etc/supervisor/conf.d` directory. 

If that directory does not exist, the configuration can be copied into file `/etc/supervisor/supervisor.conf` or `/etc/supervisord.conf` (the exact path varies by Linux OS).

Be sure to edit the file if needed to change the `user` the service runs as, and the `log` file path if required.

After placing the file, run:

```bash
sudo supervisorctl reread
sudo supervisorctl update
sudo supervisorctl start helpspot:*
```

## Systemd

The `helpers/init/helpspot.service` file can be placed in directory `/etc/systemd/system/` or `/lib/systemd/system/helpspot.service`.

> Note that we recommend using Supervisord instead of Systemd.

After placing the file, run:

```bash
sudo systemctl enable helpspot
sudo systemctl start helpspot
```
