<?php

// SECURITY: Don't allow direct calls to this file outside the context of HelpSpot
if (! defined('cBASEPATH')) {
    die();
}

/* EDITING NOTES
1. Some strings contain %s symbols, these must be maintained
2. Any single quotes must be preceded by a slash like this:  \'  ex: there\'s
3. If you modify this file, be sure to back it up in case you overwrite it during an upgrade by accident
*/

define('lg_admin_settings_title', 'HelpSpot Settings');
define('lg_admin_settings_savebutton', 'Save Settings');
define('lg_admin_settings_saved', 'Settings Saved');
define('lg_admin_settings_on', 'On');
define('lg_admin_settings_off', 'Off');
define('lg_admin_settings_hsauth', 'HelpSpot Internal');
define('lg_admin_settings_blackbox', 'Black Box');
define('lg_admin_settings_usernamenotset', 'Your account does not have a username set for it. A username is required for logging in using Black Box authentication. In addition, you may want to add usernames for your other staff as well or they will not be able to login either.');
define('lg_admin_settings_blackboxwarn', 'You have not renamed BlackBox-base.php to BlackBox.php. Please rename the file and confirm that the Black Box function has been customized for your setup.');
define('lg_admin_settings_blackboxdesc', 'Black Box authentication allows for the creation of a custom function to authenticate HelpSpot users. The custom function will allow HelpSpot to easily tie into your single sign on system authentication. To use, customize the function in custom_code/BlackBox- base.php
											to use your authentication, rename the file BlackBox.php, and save this setting to Black Box.');
define('lg_admin_settings_saml', 'SAML2.0');
define('lg_admin_settings_saml_usernamenote', 'Your staff must have a SAML username (or email) set in their HelpSpot settings in order to login');
define('lg_admin_settings_saml_idp', 'Identity Provider (IdP)');
define('lg_admin_settings_saml_entityid', 'Entity ID');
define('lg_admin_settings_saml_entityid_ex', 'The Identity Provider identity (issuer) URL');
define('lg_admin_settings_saml_loginurl', 'Login URL (SSO)');
define('lg_admin_settings_saml_loginurl_ex', 'The Identity Provider SSO login URL');
define('lg_admin_settings_saml_logouturl', 'Logout URL (SLO)');
define('lg_admin_settings_saml_logouturl_ex', 'The Identity Provider SLO logout URL');
define('lg_admin_settings_saml_cert', 'Certificate');
define('lg_admin_settings_saml_cert_ex', 'Must be x509 certificate format. Microsoft users can find this within the Federation Metadata XML.');
define('lg_admin_settings_saml_sp', 'Service Provider (SP)');
define('lg_admin_settings_saml_sp_ex', 'Use the following information to complete any needed configuration within your Identity Provider (IdP).');
define('lg_admin_settings_saml_relaystate', 'Relay State');
define('lg_admin_settings_saml_acs', 'Assertion Consumer Service (ACS) URL');
define('lg_admin_settings_saml_signonurl', 'Login URL');
define('lg_admin_settings_saml_signouturl', 'Single Logout Service (SLS) URL');
define('lg_admin_settings_auth', 'Authentication');
define('lg_admin_settings_sesstimeout','Session Timeout');
define('lg_admin_settings_authtype', 'Authentication Type');
define('lg_admin_settings_sesstimeoutex','Length of login session before user is logged out');
define('lg_admin_settings_ldap', 'LDAP/Active Directory');
define('lg_admin_settings_ldap_accountsuffix', 'Account Suffix');
define('lg_admin_settings_ldap_accountsuffix_ex', 'The account suffix for your domain, ex: @mydomain.local');
define('lg_admin_settings_ldap_basedn', 'Base DN');
define('lg_admin_settings_ldap_basedn_ex', 'ex: DC=mydomain,DC=local');
define('lg_admin_settings_ldap_dn_control', 'Domain Controller');
define('lg_admin_settings_ldap_dn_control_ex', 'ex: dc01.mydomain.local');
define('lg_admin_settings_ldap_username', 'Admin Username');
define('lg_admin_settings_ldap_username_ex', 'A domain admin username if required to connect.');
define('lg_admin_settings_ldap_password', 'Admin Password');
define('lg_admin_settings_ldap_password_ex', 'The domain admin password');
define('lg_admin_settings_ldap_usessl', 'Use SSL');
define('lg_admin_settings_ldap_usessl_ex', 'Use SSL (LDAPS), your server needs to be setup for this, PHP needs OpenSSL installed. See: <a href="http://adldap.sourceforge.net/wiki/doku.php?id=ldap_over_ssl" target="_blank">http://adldap.sourceforge.net/wiki/doku.php?id=ldap_over_ssl</a>');
define('lg_admin_settings_ldap_usetls', 'Use TLS');
define('lg_admin_settings_ldap_noldap', 'Your server does not have the PHP LDAP library installed. That is required to use this authentication type.');
define('lg_admin_settings_ldap_usernamenote', 'Your staff must have a LDAP/AD username set in their HelpSpot settings in order to login');
define('lg_admin_settings_ldap_username', 'Username');
define('lg_admin_settings_ldap_password', 'Password');
define('lg_admin_settings_ldap_testing', 'Testing...');
define('lg_admin_settings_ldap_test', 'Test LDAP Settings');
define('lg_admin_settings_ldap_testbtn', 'Test');
define('lg_admin_settings_system', 'System');
define('lg_admin_settings_timetracking', 'Time Tracker');
define('lg_admin_settings_timetrackingon', 'Time Tracker Enabled');
define('lg_admin_settings_datetime', 'Date and Time');
define('lg_admin_settings_spamlinkct', 'Link Count for SPAM');
define('lg_admin_settings_spamlinkctdesc', 'Forum and request posts from the portal with more than this number of links will be flagged as SPAM');
define('lg_admin_settings_spamautodel', 'Automatically Delete SPAM');
define('lg_admin_settings_spamautodeldesc', 'Requests and forum posts with a SPAM probability equal to or higher than this will automatically be removed. Note: A setting of 95 or higher is generally recommended. Set to 0 to disable');
define('lg_admin_settings_spamtimeip', 'Form Time/IP Validation');
define('lg_admin_settings_spamtimeipdesc', 'Validates the form submitted in the portal is not old (ex: previously stored by a spam bot) and is coming from the IP the page was served to. Note: There is a small risk actually customers may be impacted if this is of concern, select to off.');
define('lg_admin_settings_captchatext', 'Text Captcha');
define('lg_admin_settings_captchare', 'reCaptcha Service');
define('lg_admin_settings_captcha', 'Captcha Type');
define('lg_admin_settings_captchadesc', 'Ask the portal form poster to enter a word to confirm they are not an automated form submitter. Applies to the request form and forum forms.');
define('lg_admin_settings_captchawords', 'Text Captcha Words');
define('lg_admin_settings_captchawordsdesc', 'The words used in the text captcha system. One word/phrase per line.');
define('lg_admin_settings_captcharedesc', 'reCAPTCHA is a free service of Google. It is an image/audio captcha which is more secure than the standard text captcha. To use it you need to <a href="https://www.google.com/recaptcha" target="_blank">sign up for a free API KEY</a>.');
define('lg_admin_settings_captcharepublic', 'Site Key');
define('lg_admin_settings_captchareprivate', 'Secret Key');
define('lg_admin_settings_captcharetheme', 'Visual Theme');
define('lg_admin_settings_captcharelang', 'Language');
define('lg_admin_settings_captcharetheme_clean', 'Clean');
define('lg_admin_settings_captcharetheme_red', 'Red');
define('lg_admin_settings_captcharetheme_white', 'White');
define('lg_admin_settings_captcharetheme_blackglass', 'Black Glass');
define('lg_admin_settings_captcharelang_en', 'English');
define('lg_admin_settings_captcharelang_nl', 'Dutch');
define('lg_admin_settings_captcharelang_fr', 'French');
define('lg_admin_settings_captcharelang_de', 'German');
define('lg_admin_settings_captcharelang_pt', 'Portuguese');
define('lg_admin_settings_captcharelang_es', 'Spanish');
define('lg_admin_settings_captcharelang_tr', 'Turkish');
define('lg_admin_settings_orgname', 'Help Desk Name');
define('lg_admin_settings_lang', 'Language');
define('lg_admin_settings_contactvia', 'Default Contact Method');
define('lg_admin_settings_defaulthistorysearch', 'History Search Default');
define('lg_admin_settings_request_search1', 'General Search');
define('lg_admin_settings_request_search2', 'Email Address Match');
define('lg_admin_settings_request_search3', 'Full Name Match');
define('lg_admin_settings_request_search4', 'Customer ID Match');
define('lg_admin_settings_request_search5', 'Email Domain Match');
define('lg_admin_settings_request_search6', 'Last Name Match');
define('lg_admin_settings_staffselectcontact', 'Force staff member to select');
define('lg_admin_settings_defaultemail', 'Default Send From');
define('lg_admin_settings_defaultemailex', 'The default mailbox to send public notes from when creating a request');
define('lg_admin_settings_tz', 'System Time Zone');
define('lg_admin_settings_dateformat', 'Date Format');
define('lg_admin_settings_dateformatex', 'The format is described in the');
define('lg_admin_settings_dateformatlink', 'PHP manual');
define('lg_admin_settings_shortdateformat', 'Short Date Format');
define('lg_admin_settings_popupcalformat', 'Popup Calendar Date Format');
define('lg_admin_settings_popupcalshortformat', 'Popup Calendar Short Date Format');
define('lg_admin_settings_emailnotvalid', 'Notification email account not a valid email address');
define('lg_admin_settings_orgimg', 'Help Desk Image URL');
define('lg_admin_settings_orgimgex', '(optional) Provide a full URL to an image which is displayed in place of the organization name. A transparent PNG no larger than 190px wide by 40px high is recommended.');
define('lg_admin_settings_notname', 'Notification Email Address Name');
define('lg_admin_settings_notacct', 'Notification Email Address');
define('lg_admin_settings_notnameex', 'Name shown in emails sent from this account');
define('lg_admin_settings_forumemailacct', 'Notification Email Address');
define('lg_admin_settings_forumemailacctex', 'Email address HelpSpot uses as the "reply to" when sending notifications to forum thread subscribers');
define('lg_admin_settings_forumname', 'Notification Name');
define('lg_admin_settings_forumnameex', 'The name people will see in their mail clients when subscribing to a forum thread via email');
define('lg_admin_settings_notacctex', 'Email address HelpSpot uses as the "reply to" when sending notifications. Using a mailbox integrated into HelpSpot will allow for continued tracking of all exchanges.');
define('lg_admin_settings_allow_err_rep', 'Customer Connect');
define('lg_admin_settings_allow_err_repex', 'Allow HelpSpot to send reports back to UserScape of HelpSpot usage and errors. Reports are used to improve security, stability, for feature planning, and more.');
define('lg_admin_settings_allowbatch', 'Allow Batch Closing (Filters)');
define('lg_admin_settings_allowbatchex', 'Batch close option will be available in all filters');
define('lg_admin_settings_allowbatchrespond', 'Allow Batch Responding (Filters)');
define('lg_admin_settings_allowbatchrespondex', 'In all filters, allow batch respond to many requests simultaneously');
define('lg_admin_settings_feedsenabled', 'RSS Feeds Enabled');
define('lg_admin_settings_feedcopyright', 'RSS Feeds Copyright');
define('lg_admin_settings_embedmedia', 'Embed audio files into request history');
define('lg_admin_settings_daystoleavetrash', 'Trash Delete Delay');
define('lg_admin_settings_daystoleavetrashex', 'Requests will be deleted after specified number of days in the trash filter');
define('lg_admin_settings_neverdeletetrash', 'Never delete trashed requests');
define('lg_admin_settings_maxresults', 'Max Results to Display per page');
define('lg_admin_settings_maxresultsex', 'Limits the maximum number of requests per page shown in filters and search results sets');
define('lg_admin_settings_virtualarchive', 'Filter Within Previous (days)');
define('lg_admin_settings_virtualarchiveex', 'Limit filters to results within this many previous days (filters with specific or relative dates are unaffected). 0 for off.');
define('lg_admin_settings_savedraftsevery', 'Draft Save Frequency');
define('lg_admin_settings_savedraftseveryex', 'While a staffer is typing in the request screen note box save a draft this often (in seconds)');
define('lg_admin_settings_saveattach', 'Attachment Storage Location');
define('lg_admin_settings_saveattachex', 'Define where request history attachments are stored. Database is recommended unless you have very high volume or large attachment sizes.');
define('lg_admin_settings_saveattach_db', 'HelpSpot Database');
define('lg_admin_settings_saveattach_file', 'Server File System');
define('lg_admin_settings_saveattach_path', 'Attachment File System Directory');
define('lg_admin_settings_saveattach_pather', 'Attachment File System Directory is not writable');
define('lg_admin_settings_saveattach_pathex', 'Directory where attachments are saved. This directory must be fully writable by the web server and should not end in a slash (ex: /usr/files/helpspot). <b>The directory should be outside the web root</b>.');
define('lg_admin_settings_striphtml', 'History Rendering');
define('lg_admin_settings_htmldisplay', 'Display HTML');
define('lg_admin_settings_htmlremove', 'Remove HTML');
define('lg_admin_settings_htmlescape', 'Escape HTML');
define('lg_admin_settings_serious', 'Serious Mode');
define('lg_admin_settings_seriousex', 'Prevent the few small easter eggs in the system. ex: empty inbox quotes');
define('lg_admin_settings_striphtmldesc', 'HTML in requests can be either displayed, escaped or removed from the request history.');
define('lg_admin_settings_htmlallowed', 'Do not remove tags provided above (they will still be escaped). Format as list of tags: &lt;p&gt; &lt;br&gt; &lt;b&gt; &lt;i&gt;');
define('lg_admin_settings_wysiwyg', 'Use the WYSIWYG Editor in the Knowledge Books');
define('lg_admin_settings_emailintegration', 'Email Integration');
define('lg_admin_settings_htmlemailsbox', 'HTML Email');
define('lg_admin_settings_htmlemails_wysiwyg', 'WYSIWYG (visual editor)');
define('lg_admin_settings_htmlemails_markdown', 'Formatted Text (auto convert text to HTML)');
define('lg_admin_settings_htmlemails_filterimg', 'Strip Image (IMG) Tags');
define('lg_admin_settings_htmlemails_filterimgex', 'Strips image tags embedded in HTML emails to help protect the system from spammers');
define('lg_admin_settings_reply_as_public', 'Replies to notification emails are public');
define('lg_admin_settings_reply_as_publicex', 'When staff reply to an email notification about a request the reply will be forwarded through HelpSpot as a public note to the customer.');
define('lg_admin_settings_htmlemails_editor', 'HTML Editor Type');
define('lg_admin_settings_htmlemails_editorex', 'The WYSIWYG editor is a visual editor similar to Microsoft Word. Formatted Text will convert simple text to HTML.');
define('lg_admin_settings_htmlemails', 'Enable HTML for Notes');
define('lg_admin_settings_htmlemails_wysiwygex', 'Separate each element with a comma.');
define('lg_admin_settings_htmlemails_wysiwyg_values', 'Show Valid Values');
define('lg_admin_settings_htmlemails_wysiwyg_row1', 'WYSIWYG Button Row 1');
define('lg_admin_settings_htmlemails_wysiwyg_row2', 'WYSIWYG Button Row 2');
define('lg_admin_settings_htmlemails_wysiwyg_row3', 'WYSIWYG Button Row 3');
define('lg_admin_settings_htmlemails_css', 'WYSIWYG Custom CSS Style Sheet');
define('lg_admin_settings_allowattachments', 'Allow Email Attachments');
define('lg_admin_settings_excludemimes', 'Forbidden Attachment Extensions');
define('lg_admin_settings_excludemimesex', 'Should be a comma separated list (ex:zip,exe,swf)');
define('lg_admin_settings_emailloop', 'Duplicate Check');
define('lg_admin_settings_emailloopex', 'Compare incoming messages to previous requests this many seconds back. Identical requests within this time period will be ignored. (set to 0 to disable)');
define('lg_admin_settings_emaildaysafter', 'Reopening Closed Requests Before');
define('lg_admin_settings_emaildaysafter_always', 'Always Reopen');
define('lg_admin_settings_emaildaysafter_never', 'Never Reopen');
define('lg_admin_settings_inseconds', '(in seconds)');
define('lg_admin_settings_emaildaysafterex', 'Replies to closed requests will automatically be reopened, UNLESS older than this many days');
define('lg_admin_settings_maxattachsize', 'Max Attachment Size');
define('lg_admin_settings_maxattachsizeex', 'Note: large emails may need additional configuration, see <a href="https://support.helpspot.com/index.php?pg=kb.page&id=34" target="_blank">handling large email file attachments</a>.');
define('lg_admin_settings_outboundemail', 'Send Outbound Email Via');
define('lg_admin_settings_outboundemailex', 'SMTP recommended for best deliverability and error reporting');
define('lg_admin_settings_smtptest', 'Outbound Email Test');
define('lg_admin_settings_emailmaximport', 'Maximum Emails to Retrieve at Once');
define('lg_admin_settings_emailmaximportex', 'This setting protects the system from duplicating emails when there are more emails in a mailbox than can be imported in one execution of the tasks.php script. This setting is per mailbox.');
define('lg_admin_settings_prefix', 'Request ID Prefix');
define('lg_admin_settings_prefixex', 'A unique set of letters which are appended to the request ID\'s in outbound emails. Use this to prevent conflicts when sending emails between HelpSpot installations. The prefix should only contain letters. Leave this empty to have no prefix.');
define('lg_admin_settings_phpmail', 'PHP Mail Function');
define('lg_admin_settings_spamfilter', 'SPAM Filter');
define('lg_admin_settings_spamfilterex', 'Note, the "on for checking only" option should only be selected after the system has been thoroughly trained (usually several months of training)');
define('lg_admin_settings_spamfilter_on', 'On');
define('lg_admin_settings_spamfilter_checkonly', 'On for checking only, no training');
define('lg_admin_settings_spamfilter_off', 'Off');
define('lg_admin_settings_debugtasks', 'Enable tasks.php Debugging Output');
define('lg_admin_settings_debugtasksex', 'Once enabled you can visit tasks.php in your browser and see details information on the emails being imported.');
define('lg_admin_settings_spamsettings', 'Spam Settings');
define('lg_admin_settings_spam_whitelist', 'Allow List');
define('lg_admin_settings_spam_whitelistex', 'Never mark as spam. One email (or header string) per line. Searches the entire email header for a match.');
define('lg_admin_settings_spam_blacklist', 'Deny List');
define('lg_admin_settings_spam_blacklistex', 'Always mark as spam. One email (or header string) per line. Searches the entire email header for a match.');
define('lg_admin_settings_loopnew', 'New Request Loop Protection');
define('lg_admin_settings_loopnewex', 'Prevents the mailbox auto replies from creating a looping situation. If the below conditions are met auto replies will be turned off to that email address until the conditions are no longer met.');
define('lg_admin_settings_loopnewtime', 'Time Period');
define('lg_admin_settings_loopnewtimeex', 'Look back over this time period to check for looping.');
define('lg_admin_settings_loopnewct', 'Max emails in time period');
define('lg_admin_settings_loopnewctex', 'Number of emails from one address over the time period which will engage loop protection.');
define('lg_admin_settings_min', 'Minutes');
define('lg_admin_settings_hour', 'Hour');
define('lg_admin_settings_hours', 'Hours');
define('lg_admin_settings_globalbcc', 'Global BCC');
define('lg_admin_settings_globalbcc_note', 'An email address which will be BCC\'d on emails sent out of the system');
define('lg_admin_settings_globalbcc_typeall', 'All outbound emails');
define('lg_admin_settings_globalbcc_typepublic', 'Only public notes to customers');
define('lg_admin_settings_replyabove', 'Reply Above Text');
define('lg_admin_settings_replyaboveex', 'The line inserted in emails used to remove quoted history inserted by email clients');
define('lg_admin_settings_emailopt', 'General Email Settings');
define('lg_admin_settings_smtpconf', 'SMTP Configuration');
define('lg_admin_settings_smtp', 'SMTP Server(s)');
define('lg_admin_settings_smtpauth', 'Use SMTP Authentication');
define('lg_admin_settings_smtpproto', 'SMTP Security Protocol');
define('lg_admin_settings_smtpprotoex', 'Use TLS if you are unsure if your server supports TLS v1.2');
define('lg_admin_settings_smtpprotolabeldefault', 'Default (Use these if unsure)');
define('lg_admin_settings_smtpprotolabeladvanced', 'Advanced (If the mail server requires a specific protocol)');
define('lg_admin_settings_smtpprotonone', 'None');
define('lg_admin_settings_smtpprotossl', 'SSL');
define('lg_admin_settings_smtpprototls', 'TLS');
define('lg_admin_settings_smtpprototlsv12', 'TLS v1.2');
define('lg_admin_settings_smtphost', 'SMTP Host');
define('lg_admin_settings_smtphostex', 'URL to SMTP server. e.g. smtp2.example.com');
define('lg_admin_settings_smtpuser', 'SMTP Username');
define('lg_admin_settings_smtppass', 'SMTP Password');
define('lg_admin_settings_smtppass_msg', 'Leave blank unless changing');
define('lg_admin_settings_smtptimeout', 'SMTP Timeout');
define('lg_admin_settings_smtphelo', 'SMTP HELO');
define('lg_admin_settings_smtpheloex', 'This is normally left blank');
define('lg_admin_settings_smtpport', 'SMTP Port');
define('lg_admin_settings_livelookup', 'Live Lookup');
define('lg_admin_settings_livelookupex', 'Live Lookup allows you to return information on your customers to HelpSpot in real time.');
define('lg_admin_settings_livelookupexinst', 'Instructions');
define('lg_admin_settings_uselivelookup', 'Live Lookup Enabled');
define('lg_admin_settings_charencoding', 'XML Character Encoding');
define('lg_admin_settings_charencodingex', 'The character encoding your Live Lookup XML is returned in. Due to PHP limitations only these 3 are acceptable values.');
define('lg_admin_settings_lltype', 'Lookup Via');
define('lg_admin_settings_llpath', 'Live Lookup Search Source');
define('lg_admin_settings_lladd', 'Add Another Search Source');
define('lg_admin_settings_llpathtoscript', 'Path to Script');
define('lg_admin_settings_llsearchname', 'Search Name');
define('lg_admin_settings_llsearchnameex', 'EX: SAP, Active Directory, CRM ABC');
define('lg_admin_settings_lltypeex', 'Live lookups can be done via the command line or HTTP');
define('lg_admin_settings_llpathex', 'Full path to the file that generates the XML. If using HTTP the path must start with http://');
define('lg_admin_settings_llauto', 'Automatically Run');
define('lg_admin_settings_llautoex', 'Run Live Lookup when a staff member enters the request page if the above field is empty. Search source #1 is always used.');
define('lg_admin_settings_llautonorun', 'Do not automatically run');
define('lg_admin_settings_ws', 'Web Service API');
define('lg_admin_settings_wsex', 'Programmatically access HelpSpot. Create requests, run filters, and more.');
define('lg_admin_settings_wsexinst', 'Instructions');
define('lg_admin_settings_wspub', 'Public API');
define('lg_admin_settings_wspriv', 'Private API');
define('lg_admin_settings_wspubcols', 'Public API Return Columns');
define('lg_admin_settings_wspubcolsex', 'The data columns each public API method will return in the results of the method call.');
define('lg_admin_settings_cmd', 'Command Line');
define('lg_admin_settings_http', 'HTTP(s) - via GET');
define('lg_admin_settings_httppost', 'HTTP(s) - via POST');
define('lg_admin_settings_forums', 'Forums');
define('lg_admin_settings_pagesize', 'Topics per Page');
define('lg_admin_settings_enablepubforumfeeds', 'RSS Feeds Enabled');
define('lg_admin_settings_feedsize', 'Topics in the RSS Feed');
define('lg_admin_settings_closeafter', 'Close Topics After');
define('lg_admin_settings_kb', 'Knowledge Books');
define('lg_admin_settings_wysiwygstyle', 'WYSIWYG Custom Stylesheet');
define('lg_admin_settings_styleex', 'CSS styles you add here will be available in the WYSIWYG editor. Use this to keep a consistent style to all of your pages.');
define('lg_admin_settings_portal', 'Portal');
define('lg_admin_settings_terms_enable','Ask customer to accept privacy policy and terms');
define('lg_admin_settings_portalterms','URL of terms of service');
define('lg_admin_settings_portalprivacy','URL of privacy policy');
define('lg_admin_settings_portalterms_info','If you enter a URL, then the users must accept before submitting a request');
define('lg_admin_settings_portalphone', 'Phone Support Number');
define('lg_admin_settings_portalphoneex', 'Filling this in will add the phone number to the bottom of the portal navigation');
define('lg_admin_settings_portalmsg', 'Portal Homepage Message (HTML Accepted)');
define('lg_admin_settings_formformat', 'Portal Request Form Format');
define('lg_admin_settings_formformatex', 'The detailed format will allow for greater structure to the information provided by customers');
define('lg_admin_settings_autoreply', 'Portal Request Form Auto Reply');
define('lg_admin_settings_autoreplyex', 'When the portal form is submitted, should the customer receive an automated email reply');
define('lg_admin_settings_detailedformat', 'Detailed Format (3 questions)');
define('lg_admin_settings_simpleformat', 'Simple Format (single text box)');
define('lg_admin_settings_allowuploads', 'Allow file attachments');
define('lg_admin_settings_portalsearchontype', 'Show Request History Based On');
define('lg_admin_settings_portalsearchontypeex', 'When a customer logs into the request check portal area show them their request history for just their email account or for any customer ID ever associated with this email account. The second option is generally used to allow all members of a single organization to see all requests submitted by that organization.');
define('lg_admin_settings_portalsearchontypeemail', 'Email account');
define('lg_admin_settings_portalsearchontypeid', 'Customer ID\'s associated with an email account');
define('lg_admin_settings_portalauthtype', 'Request History Login Type');
define('lg_admin_settings_portalauthtypeex', 'The type of authentication system to use with the request check login system. Black Box allows you to authenticate users against your own login system. Please see our support site for more <a href="https://support.helpspot.com/index.php?pg=kb.page&id=186">details on black box</a>.');
define('lg_admin_settings_portalauthtypebb', 'Black Box');
define('lg_admin_settings_portalauthtypeint', 'HelpSpot Internal');
define('lg_admin_settings_portalauthtypebbex', 'To use Black Box you must have the file BlackBoxPortal.php in your custom_code folder.');
define('lg_admin_settings_portalauthtypesamlex', 'Use SAML for Portal authentication.');
define('lg_admin_portals_require_auth', 'Require Portal Authentication');
define('lg_admin_portals_require_auth_ex', 'Users will not be able to submit requests or browse knowledge bases until they login');
define('lg_admin_settings_bizhours', 'Business Hours');
define('lg_admin_settings_bizhours_start', 'Start');
define('lg_admin_settings_bizhours_end', 'End');
define('lg_admin_settings_bizhours_nohours', 'Off Day');
define('lg_admin_settings_bizhours_holidays_label', 'Holidays');
define('lg_admin_settings_bizhours_holidays_erdate', 'This date already exists');
define('lg_admin_settings_bizhours_holidays_desc', 'Override business hours for a specific date by creating a holiday. Marking the holiday as an off day means no businesss hours are available that day.');
define('lg_admin_settings_bizhours_date', 'Date');
define('lg_admin_settings_monday', 'Monday');
define('lg_admin_settings_tuesday', 'Tuesday');
define('lg_admin_settings_wednesday', 'Wednesday');
define('lg_admin_settings_thursday', 'Thursday');
define('lg_admin_settings_friday', 'Friday');
define('lg_admin_settings_saturday', 'Saturday');
define('lg_admin_settings_sunday', 'Sunday');
define('lg_admin_settings_bizhours_error', 'One of your business hours has an end time before the start time');
define('lg_admin_settings_prefix_error', 'The email prefix should contain only letters');
define('lg_admin_settings_allow_cc', 'Allow CC email addresses');
define('lg_admin_settings_allow_subject', 'Allow customer defined subject');
define('lg_admin_settings_workers', 'Workers');
define('lg_admin_settings_workers_restart', 'Restart Workers');
define('lg_admin_settings_workers_restart_info', 'This will restart your queue workers');
define('lg_admin_settings_workers_restarted', 'The workers have been restarted');
define('lg_admin_settings_reply_above_slash_error', 'The reply above text can not contain a slash `/`');
