<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */
require_once cBASEPATH.'/helpspot/lib/api.hdcategories.lib.php';

/**
 * Get public categories.
 */
class Savant2_Plugin_Categories extends Savant2_Plugin
{
    /**
     * Store result set here.
     *
     *
     * @var array
     */
    public $rs = [];

    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {
        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Return highlighted pages.
     *
     *
     * @param none
     *
     * @return array of pages
     */
    public function getCategories()
    {

        //Get RS if needed or else return
        if (empty($this->rs)) {
            $result = apiGetPublicCategories();
            $custom_fields = apiGetCustomFields(); //Get custom fields for public check below

            $this->rs = rsToArray($result, 'xCategory', false);

            //If we're in a remote portal only show selected categories
            if (isset($GLOBALS['hs_multiportal'])) {
                foreach ($this->rs as $id=>$cat) {
                    if (! in_array($cat['xCategory'], $GLOBALS['hs_multiportal']->categories)) {
                        unset($this->rs[$id]);
                    }
                }
            }

            foreach ($this->rs as $k=>$v) {
                //Custom fields
                if (! empty($v['sCustomFieldList'])) {
                    $checked_fields = [];
                    $fields = hs_unserialize($v['sCustomFieldList']);

                    foreach ($fields as $k=>$fid) {
                        if (isset($custom_fields[$fid]) && $custom_fields[$fid]['isPublic']) {
                            $checked_fields[] = $fid;
                        }
                    }

                    $this->rs[$v['xCategory']]['sCustomFieldList'] = $checked_fields;
                } else {
                    $this->rs[$v['xCategory']]['sCustomFieldList'] = [];
                }

                //Staff list
                if (! empty($v['sPersonList'])) {
                    $this->rs[$v['xCategory']]['sPersonList'] = hs_unserialize($v['sPersonList']);
                } else {
                    $this->rs[$v['xCategory']]['sPersonList'] = [];
                }
            }
        }

        return $this->rs;
    }

    /**
     * Return public cat count.
     *
     *
     * @param none
     *
     * @return int
     */
    public function count()
    {
        if (empty($this->rs)) {
            $this->getCategories();
        }

        return count($this->rs);
    }
}
