<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */
require_once cBASEPATH.'/helpspot/lib/api.kb.lib.php';

/**
 * Get the latest forum topics and return as array.
 */
class Savant2_Plugin_KB_Books extends Savant2_Plugin
{
    /**
     * Store result set here.
     *
     *
     * @var ADODB Record Set
     */
    public $rs = [];

    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {
        //Get RS if needed or else return
        if (empty($this->rs)) {
            $result = apiGetBooks(0);
            $this->rs = rsToArray($result, 'xBook');

            //If we're in a remote portal and books have been specified only keep results for specified books
            if (isset($GLOBALS['hs_multiportal'])) {
                foreach ($this->rs as $id=>$book) {
                    if (! in_array($id, $GLOBALS['hs_multiportal']->kbs)) {
                        unset($this->rs[$id]);
                    }
                }
            }
        }

        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Return array of books.
     *
     *
     * @param none
     *
     * @return array of books
     */
    public function getBooks()
    {
        return $this->rs;
    }

    /**
     * Return record count of books in DB.
     *
     *
     * @param none
     *
     * @return number count
     */
    public function count()
    {
        return count($this->rs);
    }
}
