<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */
require_once cBASEPATH.'/helpspot/lib/api.kb.lib.php';

/**
 * Get the latest forum topics and return as array.
 */
class Savant2_Plugin_KB_PageDownloads extends Savant2_Plugin
{
    /**
     * Store result set here.
     *
     *
     * @var ADODB Record Set
     */
    public $rs = [];

    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {

        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Set array of docs to rs.
     *
     *
     * @param pageid
     *
     * @return none
     */
    public function _setDocs($id)
    {
        $result = apiGetPageDocs($id);

        //Store in array by pageid. This allows the array to store multiple pages worth of doc info.
        //May use this ability to create download pages in the future.
        $this->rs[$id] = rsToArray($result, 'xDocumentId');
    }

    /**
     * Return array of books.
     *
     *
     * @param pageid
     *
     * @return array of books
     */
    public function getDownloads($id)
    {
        if (empty($this->rs[$id])) {
            $this->_setDocs($id);
        }

        return $this->rs[$id];
    }

    /**
     * Return record count of books in DB.
     *
     *
     * @param pageid
     *
     * @return number count
     */
    public function count($id)
    {
        if (empty($this->rs[$id])) {
            $this->_setDocs($id);
        }

        return count($this->rs[$id]);
    }
}
