<?php

namespace HS\Auth\OAuth;

use Carbon\Carbon;
use Google_Client;
use Google_Service_Gmail;

class Google extends Credentials
{
    protected $scopes = [
        'openid',
        'profile',
        'email',
        Google_Service_Gmail::GMAIL_MODIFY,
        Google_Service_Gmail::GMAIL_LABELS
    ];


    public function refresh()
    {
        $client = new Google_Client([
            'clientId'      => config('services.google.client_id'),
            'client_id'     => config('services.google.client_id'),
            'clientSecret'  => config('services.google.client_secret'),
            'client_secret' => config('services.google.client_secret'),
            'scopes'        => $this->getScopes(),
            'accessType'    => 'offline',
        ]);

        $client->setAccessToken([
            'access_token' => $this->token,
            'refresh_token' => $this->refreshToken,
            'expires_in' => $this->expiresAt->timestamp,
        ]);

        $newToken = $client->fetchAccessTokenWithRefreshToken($this->refreshToken);

        if (isset($newToken['error']) && ! empty($newToken['error'])) {
            throw new \Exception('Google oAuth refresh token error: "'.$newToken['error'].'" with description "'.($newToken['error_description'] ?? 'no description provided').'"');
        }

        return new static($newToken['access_token'], $newToken['refresh_token'], Carbon::now()->addSeconds($newToken['expires_in']));
    }

    protected function getScopes()
    {
        $scopes = explode(' ', trim(config('services.google.scopes')));

        return empty($scopes)
            ? $this->scopes
            : $scopes;
    }
}
