<?php

namespace HS\Auth\OAuth;

use Illuminate\Http\Client\Response;

class OAuthException extends \Exception
{
    public static function invalidResponse($provider, Response $response)
    {
        return new static('Invalid response from '.$provider.'. Status: '.$response->status().' with body: '.$response->body());
    }

    public static function invalidData($provider, $field='access token')
    {
        return new static('No '.$field.' provided by '.$provider);
    }
}
