<?php

namespace HS\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Queue\QueueManager;

class ClearQueueJobCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'queue:clear-job
        {job : Fully qualified classname (the job type to delete) e.g. "HS\\\IncomingMail\\\Jobs\\\FetchMail"}
        {--Q|queue=default : The queue to delete from, e.g. "default" or "high"}
        {--c|connection=redis : The queue connection to use, e.g. "database" or "redis"}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove jobs of a specific type';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('The job type to delete: '.$this->argument('job'));
        $this->info('On queue: '.$this->option('queue'));

        if( ! class_exists($this->argument('job'))) {
            $this->error('class "'.$this->argument('job').'" does not exist');
            return 1;
        }

        $connection = app(QueueManager::class)->connection($this->option('connection'));

        while ($job = $connection->pop($this->option('queue'))) {
            if ($this->argument('job') == $job->payload()['displayName']) {
                $this->info('Deleting job: '.$job->getJobId());
                $job->delete();
            }
        }

        return 0;
    }
}
