<?php

namespace HS\Console\Commands;

use HS\Mailbox;
use HS\IncomingMail\Jobs\FetchMail as DoFetchmail;

use Illuminate\Console\Command;
use Illuminate\Support\Str;

class FetchMail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:fetch {--id=*}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check a specific mailbox now (not queued)';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (! defined('IN_PORTAL')) {
            define('IN_PORTAL', false);
        }

        $mailboxIds = $this->parseMailboxIds();

        if (empty($mailboxIds)) {
            $this->error('no mailbox id\'s provided, please use the --id flag, e.g. --id=1  or  --id=1,2,3');
            return 1;
        }

        $transaction = Str::uuid()->toString();

        foreach($mailboxIds as $mailboxId) {
            if ($mailbox = Mailbox::find($mailboxId)) {
                (new DoFetchmail($mailbox, $transaction))
                    ->handle();
            }

        }
    }

    /**
     * Grab array of mailbox IDs and also parse
     * each to be backwards compatible with helpspot
     * version 4 `--id` option style
     * e.g. new style: --id=1 --id=2 --id=3
     *      old style: --id=1,2,3.
     */
    protected function parseMailboxIds()
    {
        $ids = $this->option('id');

        array_walk($ids, function (&$item) {
            $item = explode(',', $item);
        });

        return collect($ids)->flatten()->map(function ($value) {
            return trim($value);
        })->toArray();
    }
}
