<?php

namespace HS\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Arr;

class GarbageCollectSession extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'session:gc';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run session gc';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $session = session();
        $lifetime = Arr::get($session->getSessionConfig(), 'lifetime') * 60;
        $session->getHandler()->gc($lifetime);
        return 0;
    }
}
