<?php

namespace HS\IncomingMail\Mailboxes;

interface Mailbox
{

    /**
     * @return mixed
     */
    public function connect();

    /**
     * @return mixed
     */
    public function messageCount();

    /**
     * @param $id
     * @return mixed
     */
    public function getMessage($id);

    /**
     * @param $message
     * @return mixed
     */
    public function getUid($message);

    /**
     * @param $id
     * @return mixed
     */
    public function delete($id);

    /**
     * @param $id
     * @return mixed
     */
    public function archive($id);

    /**
     * @return mixed
     */
    public function expunge();

    /**
     * @return array
     */
    public function getMessages();
}
