<?php

namespace HS\IncomingMail\Processors;

use HS\IncomingMail\Message;

class LoopCheck
{
    /**
     *
     * @param Message $message
     * @return bool
     */
    public function newMessageInLoop(Message $message)
    {
        $hash = $this->getHash($message);
        if (! $hash) {
            return false;
        }

        $check = $GLOBALS['DB']->Execute( 'SELECT xRequest FROM HS_Request
										   WHERE fOpenedVia = 1 AND dtGMTOpened > ? AND sTitle = ? AND sRequestHash = ?',
										   [time()-hs_setting('cHD_EMAILLOOP_TIME'), $message->getSubject(lg('lg_no_subject')), $hash] );
        if (is_object($check) && $check->RecordCount() > 0) {
            return true;
        }
        return false;
    }

    /**
     * See if we should send out an autoresponder.
     *
     * @param $email
     * @return bool
     */
    public function shouldAutoRespond($email)
    {
        $check = $GLOBALS['DB']->GetOne('SELECT COUNT(*) AS loopct FROM HS_Request WHERE sEmail = ? AND dtGMTOpened > ?',
            [$email, time()-hs_setting('cHD_EMAILLOOP_TIME')]
        );

        if ($check > 0) {
            return true;
        }
        return false;
    }

    /**
     * Check that the same message hasn't been sent to this request before
     * over the last X time period. If it has then delete it without importing it.
     *
     * @param Message $message
     * @param int $requestId
     * @param int $time The time() the update request started coming in.
     * @return bool
     */
    public function updateInLoop(Message $message, $requestId, $time)
    {
        $hash = $this->getHash($message);
        if (! $hash) {
            return false;
        }

        //Limit this to just one request over a certain time span since it is possible for someone
        // to send the same message in and really want to do it in different requests or at different times
        $loopCheck = $GLOBALS['DB']->GetOne('SELECT COUNT(*) AS loopct FROM HS_Request_History WHERE
            sRequestHistoryHash <> ?
            AND sRequestHistoryHash = ?
            AND xRequest = ?
            AND dtGMTChange > ?', ['', $hash, $requestId, $time-strtotime(hs_setting('cHD_EMAIL_LOOPCHECK_TIME'))]);

        if ($loopCheck > 0) {
            return true;
        }
        return false;
    }

    /**
     * Do an MD5 hash of the message which is used to find duplicate emails in the loop checks
     * @param Message $message
     * @return string
     */
    protected function getHash(Message $message)
    {
        $body = utf8_trim($message->getParsedBody());

        // If for some reason the body is blank we want to bail out and not do any checks,
        // in theory this should never happen because we have an empty body check when fetching mail.
        if ($body == "") {
            return false;
        }
        return md5($body);
    }
}
