<?php

namespace HS\Mail;


use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;

class Attachments extends Collection
{
    /**
     * @param array $helpspotDocs
     * @return Attachments
     */
    public static function parse($helpspotDocs=[]) {

        $attachments = new static([]);

        foreach (($helpspotDocs['error'] ?? []) as $key => $error) {
            if (! empty($helpspotDocs['name'][$key])) {
                if ($error == UPLOAD_ERR_OK) {
                    if (isset($helpspotDocs['xDocumentId'][$key]) && ! empty($helpspotDocs['xDocumentId'][$key])) {
                        Log::debug('['.__CLASS__.'] Prepping email attachment HelpspotAttachment', [
                            'xDocumentId' => $helpspotDocs['xDocumentId'][$key],
                            'name' => $helpspotDocs['name'][$key],
                            'tmp_name' => $helpspotDocs['tmp_name'][$key],
                            'type' => $helpspotDocs['type'][$key],
                            'is_inline' => $helpspotDocs['type'][$key],
                            'transaction' => get_transaction_id(),
                        ]);

                        $isEmbed = isset($helpspotDocs['is_inline'][$key]) && $helpspotDocs['is_inline'][$key] == true;
                        $attachments->push(new HelpspotAttachment($helpspotDocs['xDocumentId'][$key], $isEmbed));
                    } else {
                        // If we don't have an xDocumentId for some reason, use the UploadedAttachment
                        // This should not end up being used, but we're keeping it here just in case.
                        // This should get removed after testing. If you're reading this years later - Hi, welcome to Real Code™
                        Log::debug('['.__CLASS__.'] Prepping email attachment UploadedAttachment', [
                            'name' => $helpspotDocs['name'][$key],
                            'tmp_name' => $helpspotDocs['tmp_name'][$key],
                            'type' => $helpspotDocs['type'][$key],
                            'is_inline' => $helpspotDocs['type'][$key],
                            'transaction' => get_transaction_id(),
                        ]);
                        if (isset($helpspotDocs['is_inline'][$key]) && $helpspotDocs['is_inline'][$key] == true) {
                            $attachments->push(new UploadedAttachment(
                                $path=$helpspotDocs['tmp_name'][$key],
                                $fileName=$helpspotDocs['name'][$key],
                                $contentType=$helpspotDocs['type'][$key],
                                $cid=$helpspotDocs['content-id'][$key]
                            ));
                        } else {
                            $attachments->push(new UploadedAttachment(
                                $path=$helpspotDocs['tmp_name'][$key],
                                $fileName=$helpspotDocs['name'][$key],
                                $contentType=$helpspotDocs['type'][$key]
                            ));
                        }
                    }
                }
            }
        }

        return $attachments;
    }

    public function persist()
    {
        $this->each(function(Attachment $attachment) {
            $attachment->persist();
        });

        return $this;
    }

    public function cleanup()
    {
        $this->each(function(Attachment $attachment) {
            $attachment->cleanup();
        });

        return $this;
    }
}
