<?php

namespace HS\Mail\Mailer;


use HS\Mailbox;

class SmtpSettings
{
    /**
     * @var null|int
     */
    private $mailbox;

    /**
     * SmtpSettings constructor.
     * @param null $mailbox
     */
    public function __construct($mailbox=null)
    {
        $this->mailbox = $mailbox;
    }

    /**
     * @return SMTP
     * @throws \Exception
     */
    public function settings()
    {
        return ($this->mailbox)
            ? $this->customSmtp()
            : $this->defaultSmtp();
    }

    /**
     * @return SMTP|bool
     * @throws \Exception
     */
    protected function customSmtp()
    {
        // If mailbox not registered in globals
        if (! isset($GLOBALS['mailbox_smtp_settings'][$this->mailbox])) {
            $mailbox = Mailbox::find($this->mailbox);
            $GLOBALS['mailbox_smtp_settings'][$this->mailbox] = $mailbox;
        }

        // Only get custom SMTP if mailbox exists and has custom SMTP
        if( $GLOBALS['mailbox_smtp_settings'][$this->mailbox] && $GLOBALS['mailbox_smtp_settings'][$this->mailbox]->hasCustomSmtp() ) {
            SMTP::fromHelpSpotSettings($GLOBALS['mailbox_smtp_settings'][$this->mailbox]);
        }

        // Else return the default SMTP settings
        return SMTP::fromDefault();
    }

    /**
     * @return SMTP
     * @throws \Exception
     */
    protected function defaultSmtp()
    {
        return SMTP::fromDefault();
    }
}
