<?php

namespace HS\Mail\Tracking;


use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;

class RedisTracker
{
    public function increment()
    {
        $dateKey = sprintf("mail-sends::%s", Carbon::now('UTC')->format('Y-m-d'));
        $twoDaysInSeconds = 172800;

        try {
            if (! Redis::exists($dateKey)) {
                Redis::setex($dateKey, $twoDaysInSeconds, 1);
            } else {
                Redis::incr($dateKey);
            }
        } catch(\Exception $e) {
            Log::error($e);
        }

        return $this;
    }

    public function getSendCount()
    {
        $dateKey = sprintf("mail-sends::%s", Carbon::now('UTC')->format('Y-m-d'));

        try {
            return Redis::get($dateKey);
        } catch(\Exception $e)
        {
            Log::error($e);
        }

        return 0;
    }
}
