<?php

namespace HS\Mail\Tracking;

use \usLicense;

class Tracker
{
    public static function increment()
    {
        // Bail out if not HelpSpot Cloud hosted
        if (! isHosted()) return;

        // Only check if it's a trial
        include_once cBASEPATH.'/helpspot/pear/Crypt_RC4/Rc4.php';
        include_once cBASEPATH.'/helpspot/lib/class.license.php';

        $licenseObj = new usLicense(hs_setting('cHD_CUSTOMER_ID'), hs_setting('cHD_LICENSE'), hs_setting('SSKEY'));
        $isTrial = $licenseObj->getLicense()['trial'] ?? false;
        if (! $isTrial) {
            return;
        }

        (new RedisTracker)->increment();
    }

    public static function throwExceptionIfReachedLimit()
    {
        // Bail out if not HelpSpot Cloud hosted
        if (! isHosted()) return;

        // Only check if it's a trial
        include_once cBASEPATH.'/helpspot/pear/Crypt_RC4/Rc4.php';
        include_once cBASEPATH.'/helpspot/lib/class.license.php';

        $licenseObj = new usLicense(hs_setting('cHD_CUSTOMER_ID'), hs_setting('cHD_LICENSE'), hs_setting('SSKEY'));
        $isTrial = $licenseObj->getLicense()['trial'] ?? false;
        if (! $isTrial) {
            return;
        }

        $sendCount = (new RedisTracker)->getSendCount();

        if ($sendCount >= config('helpspot.trial_daily_send_limit', 200)) {
            throw TrialEmailLimitReached::limitReached();
        }

        return $sendCount;
    }
}
