<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AdjustHsThermostatTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Delete surveys that exist on more than on xRequest
        $results = DB::select(DB::raw('select * from (select xRequest, count(xRequest) as the_count from HS_Thermostat group by xRequest) as temp where temp.the_count > 1;'));

        foreach($results as $result)
        {
            $limit = $result->the_count - 1;

            if ($limit < 1) {
                $limit = 1;
            }

            DB::table('HS_Thermostat')
                ->where('xRequest', $result->xRequest)
                ->orderBy('xSurvey')
                ->limit($limit)
                ->delete();
        }

        Schema::table('HS_Thermostat', function (Blueprint $table) {
            // Swap old unique index for new one
            $table->dropUnique('hs_thermostat_xsurvey_xrequest_unique');
            $table->unique('xRequest');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('HS_Thermostat', function (Blueprint $table) {
            //
        });
    }
}
