<?php

// SECURITY: Don't allow direct calls
if (! defined('cBASEPATH')) {
    die();
}

//protect to only admins
if (! isAdmin()) {
    die();
}

/*****************************************
LANG
 *****************************************/
$GLOBALS['lang']->load('admin.settings');

/*****************************************
LIBS
 *****************************************/
include cBASEPATH.'/helpspot/lib/api.mailboxes.lib.php';

/*****************************************
VARIABLE DECLARATIONS
 *****************************************/
$pagebody = '';
$basepgurl = route('admin', ['pg' => 'admin.mailboxes']);
$basepgurl_crud = route('admin', ['pg' => 'admin.mailboxes.crud']);
$pagetitle = lg('lg_admin_mailboxes_title');
$tab = 'nav_admin';
$subtab = 'nav_admin_mail';
$sortby = isset($_GET['sortby']) ? $_GET['sortby'] : '';
$sortord = isset($_GET['sortord']) ? $_GET['sortord'] : '';
$action = isset($_GET['action']) ? $_GET['action'] : '';
$resourceid = isset($_GET['resourceid']) && is_numeric($_GET['resourceid']) ? $_GET['resourceid'] : 0;
$showdeleted = isset($_GET['showdeleted']) ? $_GET['showdeleted'] : 0;

if (session('feedback')) {
    $feedbackArea = displayFeedbackBox(session('feedback'), '100%');
}

$dellable = $showdeleted == 1 ? lg('lg_inactive') : '';

/*****************************************
PERFORM ACTIONS
 *****************************************/
if (! subscription()->canAdd('mailbox', \HS\Mailbox::archived(false)->count())) {
    $text = '<div style="display:flex;justify-content: space-between;margin: 20px 0;">
                <div>
                    You have reached the free plan mailbox limit. If you need more mailboxes please move to a paid account
                    <a class="action" href="https://store.helpspot.com">buy now</a>
                    or <a class="action" href="https://www.helpspot.com/talk-to-sales">contact sales</a>
                </div>
            </div>';
    $pagebody .= displaySystemBox($text);
}

/*****************************************
SETUP VARIABLES AND DATA FOR PAGE
 *****************************************/
// Get category info
$sorting = getSorting($sortby, $sortord, ['sReplyName', 'sHostname', 'sUsername']);
$data = apiGetAllMailboxes($showdeleted, $sorting);
$formaction = 'add';
$title = lg('lg_admin_mailboxes_addbox');
$button = lg('lg_admin_mailboxes_addbutton');
if (! $showdeleted) {
    $showdellink = '<a href="'.$basepgurl.'&showdeleted=1" class="">'.lg('lg_admin_mailboxes_showdel').'</a>';
} else {
    $showdellink = '<a href="'.$basepgurl.'" class="">'.lg('lg_admin_mailboxes_noshowdel').'</a>';
}

// build data table
$datatable = recordSetTable($data,[
    ['type'=>'string', 'label'=>lg('lg_admin_mailboxes_colid'), 'sort'=>0, 'width'=>'20', 'fields'=>'xMailbox'],
    ['type'=>'link', 'label'=>lg('lg_admin_mailboxes_coltype', 'Type'), 'sort'=>0, 'width'=>'20',
        'code' => '<img src="'.static_url().'/static/img5/mailbox-%s.png" style="max-width: 20px;" />',
        'fields'=>'sMailboxType', 'linkfields'=>['sMailboxType']],
    ['type'=>'link', 'label'=>lg('lg_admin_mailboxes_replyname'), 'sort'=>1,
        'code'=>'<a href="'.$basepgurl_crud.'&resourceid=%s&showdeleted='.$showdeleted.'">%s</a>',
        'fields'=>'sReplyName', 'linkfields'=>['xMailbox', 'sReplyName'], ],
    ['type'=>'string', 'label'=>lg('lg_admin_mailboxes_replyto'), 'sort'=>0, 'width'=>'120', 'fields'=>'sReplyEmail'],
    ['type'=>'string', 'label'=>lg('lg_admin_mailboxes_mbhost'), 'sort'=>1, 'width'=>'120', 'fields'=>'sHostname'],
    ['type'=>'string', 'label'=>lg('lg_admin_mailboxes_mbuser'), 'sort'=>1, 'width'=>'100', 'fields'=>'sUsername'], ],

    ['sortby'=>$sortby,
        'sortord'=>$sortord,
        'noresults'=>lg('lg_admin_mailboxes_nomailboxes'),
        'title'=>$pagetitle.$dellable,
        'title_right'=>$showdellink, ], $basepgurl_crud);

/*****************************************
PAGE OUTPUTS
 *****************************************/


// Show the main list of mailboxes.
$pagebody .= $feedbackArea;
$pagebody .= $datatable;

$pagebody .= renderInnerPageheader($title, lg('lg_admin_mailboxes_explain')).'
    <div class="card padded mailbox-select">
        <div style="padding: 20px 0 5px 0;">
            <a href="'.route('admin', ['pg' => 'admin.mailboxes.crud', 'type' => 'microsoft']).'" title="office365">
                <img src="'.static_url().'/static/img5/mailbox-microsoft.png" alt="microsoft" style="width: 40px; margin-right: 16px;" /> Microsoft 365
            </a>

            <div class="hr" style="width: 33%; margin: 10px auto;"></div>
<!-- Google is coming soon!
            <a href="'.route('admin', ['pg' => 'admin.mailboxes.crud', 'type' => 'google']).'" title="google mail">
                <img src="'.static_url().'/static/img5/mailbox-google.png" alt="google" style="width: 40px; margin-right: 16px;" title="google mail" /> Google
            </a>

            <div class="hr" style="width: 33%; margin: 10px auto;"></div>
-->
            <a href="'.route('admin', ['pg' => 'admin.mailboxes.crud', 'type' => 'custom']).'" style="line-height: 40px;" title="all other mailbox types">
                <img src="'.static_url().'/static/img5/mailbox-custom.png" alt="custom imap" style="width: 40px; margin-right: 16px;" title="custom imap" /> Custom IMAP
            </a>
        </div>
    </div>
';
