<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */

/**
 * Get the latest forum topics and return as array.
 */
class Savant2_Plugin_CustomFields extends Savant2_Plugin
{
    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {

        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Return public custom fields.
     *
     *
     * @param none
     *
     * @return array of custom fields
     */
    public function getPublicCustomFields()
    {
        $out = [];
        $fields = apiGetCustomFields();

        //If we're in a remote portal only show selected custom fields
        if (isset($GLOBALS['hs_multiportal'])) {
            foreach ($fields as $id=>$cf) {
                if (! in_array($cf['xCustomField'], $GLOBALS['hs_multiportal']->cfs)) {
                    unset($fields[$id]);
                }
            }
        }

        if (is_array($fields)) {
            foreach ($fields as $v) {
                if ($v['isPublic']) {
                    $out[$v['fieldID']] = $v;
                    $out[$v['fieldID']]['fieldName'] = hs_htmlspecialchars($v['fieldName']);

                    if (! empty($out[$v['fieldID']]['listItems'])) {
                        $out[$v['fieldID']]['listItems'] = hs_unserialize($v['listItems']);
                        if ($v['fieldType'] != 'drilldown') {
                            array_walk($out[$v['fieldID']]['listItems'], 'CleanByRef');
                        }
                    } else {
                        $out[$v['fieldID']]['listItems'] = [];
                    }
                }
            }
        }

        return $out;
    }

    /**
     * Return category public custom fields, excludes always visible fields.
     *
     *
     * @param none
     *
     * @return array of custom fields
     */
    public function getCategoryPublicCustomFields()
    {
        $out = [];
        $fields = apiGetCustomFields();

        //If we're in a remote portal only show selected custom fields
        if (isset($GLOBALS['hs_multiportal'])) {
            foreach ($fields as $id=>$cf) {
                if (! in_array($cf['xCustomField'], $GLOBALS['hs_multiportal']->cfs)) {
                    unset($fields[$id]);
                }
            }
        }

        if (is_array($fields)) {
            foreach ($fields as $v) {
                if ($v['isPublic'] && ! $v['isAlwaysVisible']) {
                    $out[$v['fieldID']] = $v;
                    $out[$v['fieldID']]['fieldName'] = hs_htmlspecialchars($v['fieldName']);

                    if (! empty($out[$v['fieldID']]['listItems'])) {
                        $out[$v['fieldID']]['listItems'] = hs_unserialize($v['listItems']);
                        if ($v['fieldType'] != 'drilldown') {
                            array_walk($out[$v['fieldID']]['listItems'], 'CleanByRef');
                        }
                    } else {
                        $out[$v['fieldID']]['listItems'] = [];
                    }
                }
            }
        }

        return $out;
    }
}
