<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */
require_once cBASEPATH.'/helpspot/lib/api.kb.lib.php';

/**
 * Get the all the highlighted pages from the DB.
 */
class Savant2_Plugin_KB_HelpfulPages extends Savant2_Plugin
{
    /**
     * Store result set here.
     *
     *
     * @var array
     */
    public $rs = [];

    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {
        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Return highlighted pages.
     *
     *
     * @param none
     *
     * @return array of pages
     */
    public function getHelpfulPages($size)
    {
        $result = apiGetMostHelpful($size);
        $this->rs = rsToArray($result, 'xPage');

        return $this->rs;
    }

    /**
     * Return record count of helpful pages in DB.
     *
     *
     * @param none
     *
     * @return number count
     */
    public function count()
    {
        if (empty($this->rs)) {
            $this->getHelpfulPages(10);
        }

        return count($this->rs);
    }
}
