<?php

/**
 * Base plugin class.
 */
require_once 'Savant2/Plugin.php';

/**
 * HelpSpot Libraries.
 */
require_once cBASEPATH.'/helpspot/lib/api.kb.lib.php';

/**
 * Get tags for a page.
 */
class Savant2_Plugin_KB_PageTags extends Savant2_Plugin
{
    /**
     * Store result set here.
     *
     *
     * @var ADODB Record Set
     */
    public $rs = [];

    /**
     * Central switcher API for the the various public methods.
     *
     *
     * @param string $method The public method to call from this class; all
     * additional parameters will be passed to the called method
     *
     * @return string XHTML generated by the public method.
     */
    public function plugin($method)
    {

        // only pass calls to public methods (i.e., no leading underscore)
        if (substr($method, 0, 1) != '_' && method_exists($this, $method)) {

            // get all arguments and drop the first one (the method name)
            $args = func_get_args();
            array_shift($args);

            // call the method, then return the tidied-up XHTML results
            return call_user_func_array([&$this, $method], $args);
        } else {
            return false;
        }
    }

    /**
     * Set array of docs to rs.
     *
     *
     * @param pageid
     *
     * @return none
     */
    public function _setTags($id)
    {
        $this->rs = $GLOBALS['DB']->GetArray('SELECT HS_Tags.xTag,HS_Tags.sTag FROM HS_Tags, HS_Tags_Map WHERE HS_Tags.xTag = HS_Tags_Map.xTag AND HS_Tags_Map.xPage = ?', [$id]);
    }

    /**
     * Return array of tags.
     *
     *
     * @param pageid
     *
     * @return array of tags
     */
    public function getTags($id)
    {
        if (empty($this->rs)) {
            $this->_setTags($id);
        }

        return $this->rs;
    }

    /**
     * Return record count of tags.
     *
     *
     * @param pageid
     *
     * @return number count
     */
    public function count($id)
    {
        if (empty($this->rs)) {
            $this->_setTags($id);
        }

        return count($this->rs);
    }
}
