{{-- Manual IMAP/POP configuration (Old School™) --}}
<div class="hr"></div>

<div class="fr">
    <div class="label ">
        <label for="sMailbox" class="datalabel req">{{ lg('lg_admin_mailboxes_mailbox') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mailboxnote') }}</div>
    </div>
    <div class="control">
        <input name="sMailbox" id="sMailbox" type="text" size="30" value="{{ formClean($mailbox->sMailbox) }}" class="{{ errorClass('sMailbox') }}">
        {{ errorMessage('sMailbox') }}
    </div>
</div>

<div id="archive-container">
    <div class="hr"></div>

    <div class="fr">
        <div class="label tdlcheckbox">
            <label for="fArchive" class="datalabel req">{{ lg('lg_admin_mailboxes_archive') }}</label>
            <div class="info">
                {{ lg('lg_admin_mailboxes_archive_note') }}
                <div style="font-weight:bold; margin-top: 6px;">{{ lg('lg_admin_mailboxes_deletemsg') }}</div>
            </div>
        </div>
        <div class="control">
            <input type="checkbox" name="fArchive" id="fArchive" class="checkbox" value="1" {{ checkboxCheck(1, $mailbox->fArchive)  }}>
            <label for="fArchive" class="switch"></label>
        </div>
    </div>
</div>

<div class="hr"></div>

<div class="fr">
    <div class="label">
        <label for="sHostname" class="datalabel req">{{ lg('lg_admin_mailboxes_mbhost') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbhostnote') }}</div>
    </div>
    <div class="control">
        <input name="sHostname" id="sHostname" type="text" size="30" value="{{ formClean($mailbox->sHostname) }}" class="{{ errorClass('sHostname') }}">
        {{ errorMessage('sHostname') }}
    </div>
</div>

<div class="hr"></div>

<div class="fr">
    <div class="label">
        <label for="sUsername" class="datalabel req">{{ lg('lg_admin_mailboxes_mbuser') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbusernote') }}</div>
    </div>
    <div class="control">
        <input  name="sUsername" id="sUsername" type="text" size="30" value="{{ formClean($mailbox->sUsername) }}" class="{{ errorClass('sUsername') }}">
        {{ errorMessage('sUsername') }}
    </div>
</div>

<div class="hr"></div>

<div class="fr">
    <div class="label">
        <label for="sPassword" class="datalabel req">{{ lg('lg_admin_mailboxes_mbpass') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbpassnote') }}</div>
    </div>
    <div class="control">
        <input name="sPassword" id="sPassword" type="password" size="30" value="" class="{{ errorClass('sPassword') }}">
        {{ errorMessage('sPassword') }}
    </div>
</div>

<div class="hr"></div>

<div class="fr">
    <div class="label">
        <label for="sPasswordConfirm" class="datalabel req">{{ lg('lg_admin_mailboxes_mbpass_confirm') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbpassnote_confirm') }}</div>
    </div>
    <div class="control">
        <input name="sPasswordConfirm" id="sPasswordConfirm" type="password" size="30" value="" class="{{ errorClass('sPasswordConfirm') }}">
        {{ errorMessage('sPasswordConfirm') }}
    </div>
</div>

<div class="hr"></div>

<div class="fr">
    <div class="label">
        <label for="sType" class="datalabel req">{{ lg('lg_admin_mailboxes_mbtype') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbtypenote') }}</div>
    </div>
    <div class="control">
        <select name="sType" id="sType" class="{{ errorClass('sType') }}">
            <optgroup label="{{ utf8_ucfirst(lg('lg_admin_mailboxes_recommended')) }}">
                <option value="imap" {{ selectionCheck('imap', $mailbox->sType) }}>IMAP</option>
                <option value="imaps" {{ selectionCheck('imaps', $mailbox->sType) }}>IMAPS {{ lg('lg_admin_mailboxes_secure') }}</option>
            </optgroup>
            <optgroup label="{{ utf8_ucfirst(lg('lg_admin_mailboxes_depreciated')) }}">
                <option style="color:#ccc;" value="pop3" {{ selectionCheck('pop3', $mailbox->sType) }}>POP3</option>
                <option style="color:#ccc;" value="pop3s" {{ selectionCheck('pop3s', $mailbox->sType) }}>POP3S {{ lg('lg_admin_mailboxes_secure') }}</option>
                <option style="color:#ccc;" value="nntp" {{ selectionCheck('nntp', $mailbox->sType) }}>NNTP</option>
                <option style="color:#ccc;" value="nntps" {{ selectionCheck('nntps', $mailbox->sType) }}>NNTPS {{ lg('lg_admin_mailboxes_secure') }}</option>
            </optgroup>
        </select>
        {{ errorMessage('sType') }}
    </div>
</div>

<div class="hr"></div>

<div class="fr">
    <div class="label">
        <label for="sPort" class="datalabel req">{{ lg('lg_admin_mailboxes_mbport') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbportnote') }}</div>
    </div>
    <div class="control">
        <input name="sPort" id="sPort" type="text" size="10" value="{{ $mailbox->sPort }}" class="{{ errorClass('sPort') }}">
        {{ errorMessage('sPort') }}
    </div>
</div>

<div class="hr"></div>

<div class="fr">
    <div class="label">
        <label for="sSecurity" class="datalabel">{{ lg('lg_admin_mailboxes_mbsecurity') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbsecurityex') }}</div>
    </div>
    <div class="control">
        <select name="sSecurity" id="sSecurity" class="{{ errorClass('sSecurity') }}">
            <option value=""></option>
            <option value="novalidate-cert" {{ selectionCheck('novalidate-cert', $mailbox->sSecurity) }}>SSL no-validate</option>
            <option value="tls/novalidate-cert" {{ selectionCheck('tls/novalidate-cert', $mailbox->sSecurity) }}>TLS no-validate</option>
            <option value="tls" {{ selectionCheck('tls', $mailbox->sSecurity) }}>TLS</option>
            <option value="notls" {{ selectionCheck('notls', $mailbox->sSecurity) }}>NOTLS</option>
        </select> {{ errorMessage('sSecurity') }}
    </div>
</div>

<div class="fr">
    <div class="label">
        <label for="sConnectionOptions" class="datalabel">{{ lg('lg_admin_mailboxes_mbconnectionoptions') }}</label>
        <div class="info">{{ lg('lg_admin_mailboxes_mbconnectionoptionsnote') }}</div>
    </div>
    <div class="control">
        <input name="sConnectionOptions" id="sConnectionOptions" type="text" size="10" value="{{ $fm['sConnectionOptions'] }}" class="{{ errorClass('sConnectionOptions') }}">
        {{ errorMessage('sConnectionOptions') }}
    </div>
</div>

<?php echo displayContentBoxTop(lg('lg_admin_mailboxes_testmailbox'), lg('lg_admin_mailboxes_testmailboxex'), '', '100%', 'test-mailbox-container'); ?>

<div id="test_mailbox_results" style="width:100%; margin: 0 0 20px 0;"></div>
<div id="secure_note" style="display:none;font-size:93%;">
    <b>{{ lg('lg_admin_mailboxes_testnotesecure') }}</b>
    <ul>
        <li>{{ lg('lg_admin_mailboxes_testnotepop') }}</li>
        <li>{{ lg('lg_admin_mailboxes_testnoteimap') }}</li>
    </ul>
</div>
<button type="button" name="test_mailbox" class="btn accent" id="test_mailbox" onclick="test_box();" >{{ lg('lg_admin_mailboxes_testmailbox') }}</button>

<?php echo displayContentBoxBottom(); ?>
